#!/usr/bin/env bash
#SBATCH --gpus=a100:1         # Request 1 A100 GPU
#SBATCH --time=01:00:00       # Set a time limit
#SBATCH --output=job.out      # Output file
#SBATCH --cpus-per-task=8     # Number of CPU cores per task
#SBATCH --mem=32G             # Memory request

source ~/.bashrc              # Load your bash profile
module load anaconda3         # Load Anaconda3 module
module load cuda/11.8.0       # Load CUDA 11.8 for A100 compatibility

source activate LLM_fresh     # Activate your Conda environment

python3 LLM_static.py         # Execute your Python script
